DROP PROCEDURE [hips].[ContactInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 15 Oct 2012
-- Description:   Gets a specific record from the Country Table
-- =============================================
CREATE PROCEDURE [hips].[ContactInsert] 
(
	@Detail VARCHAR(256),
	@ContactMethodId INT,
	@UserModified varchar(256)
)
AS
BEGIN
	SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @ContactId int

    SET @intErrorCode = 0

	INSERT INTO hips.Contact
	        ( Detail ,
	          ContactMethodId ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  (	@Detail,
				@ContactMethodId,
				GETDATE(),
				@UserModified,
				GETDATE(),
				@UserModified
	
	        )
	SELECT @intErrorCode = @@ERROR , @ContactId = SCOPE_IdENTITY()
    IF @intErrorCode = 0
    BEGIN
		SELECT  c.ContactId,
				c.Detail,
				c.ContactMethodId,
				cm.TelecommunicationType,
				cm.Description,
				cm.CdaType,
				c.DateCreated,
				c.UserCreated,
				c.DateModified,
				c.UserModified
				
		FROM  hips.Contact c
		INNER JOIN hips.ContactMethod AS cm ON cm.ContactMethodId = c.ContactMethodId
		WHERE [ContactId] = @ContactId
    END

    RETURN(@intErrorCode)


END
GO

